<?php

namespace App\Models\Client;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function commandes()
    {
        return $this->hasMany('App\Models\Commandes\Commande');
    }

    public function code_promos()
    {
        return $this->hasMany('App\Models\CodePromo\CodePromo');
    }

    public function notation_clients()
    {
        return $this->hasMany('App\Models\NotificationClient\NotificationClient');
    }

}